/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Interpolation;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.CardGroup;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.GameDictionary;
import com.megacrit.cardcrawl.helpers.Hitbox;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.helpers.PowerTip;
import com.megacrit.cardcrawl.helpers.TipHelper;
import com.megacrit.cardcrawl.localization.UIStrings;
import java.util.ArrayList;
import java.util.Scanner;

public class SingleCardViewPopup {
    private static final UIStrings uiStrings = CardCrawlGame.languagePack.getUIString("SingleCardViewPopup");
    public static final String[] TEXT = SingleCardViewPopup.uiStrings.TEXT;
    public boolean isOpen = false;
    private CardGroup group;
    private AbstractCard card;
    private AbstractCard prevCard;
    private AbstractCard nextCard;
    private Texture portraitImg = null;
    private Hitbox nextHb;
    private Hitbox prevHb;
    private Hitbox cardHb;
    private float fadeTimer = 0.0f;
    private Color fadeColor = Color.BLACK.cpy();
    private static final float LINE_SPACING = 1.53f;
    private float current_x;
    private float current_y;
    private Scanner scanner;
    private float drawScale;
    private float card_energy_w;
    private static final float DESC_OFFSET_Y2 = -12.0f;
    private static final Color CARD_TYPE_COLOR = new Color(0.35f, 0.35f, 0.35f, 1.0f);
    private static final GlyphLayout gl = new GlyphLayout();
    public static boolean isViewingUpgrade = false;
    private Hitbox upgradeHb = new Hitbox(250.0f * Settings.scale, 80.0f * Settings.scale);

    public SingleCardViewPopup() {
        this.prevHb = new Hitbox(200.0f * Settings.scale, 70.0f * Settings.scale);
        this.nextHb = new Hitbox(200.0f * Settings.scale, 70.0f * Settings.scale);
    }

    public void open(AbstractCard card, CardGroup group) {
        CardCrawlGame.isPopupOpen = true;
        if (CardCrawlGame.mode == CardCrawlGame.GameMode.CHAR_SELECT) {
            // empty if block
        }
        this.prevCard = null;
        this.nextCard = null;
        this.prevHb = null;
        this.nextHb = null;
        for (int i = 0; i < group.size(); ++i) {
            if (group.group.get(i) != card) continue;
            if (i != 0) {
                this.prevCard = group.group.get(i - 1);
            }
            if (i == group.size() - 1) break;
            this.nextCard = group.group.get(i + 1);
            break;
        }
        this.prevHb = new Hitbox(160.0f * Settings.scale, 160.0f * Settings.scale);
        this.nextHb = new Hitbox(160.0f * Settings.scale, 160.0f * Settings.scale);
        this.prevHb.move((float)Settings.WIDTH / 2.0f - 400.0f * Settings.scale, (float)Settings.HEIGHT / 2.0f);
        this.nextHb.move((float)Settings.WIDTH / 2.0f + 400.0f * Settings.scale, (float)Settings.HEIGHT / 2.0f);
        this.card_energy_w = 24.0f * Settings.scale;
        this.drawScale = 2.0f;
        this.cardHb = new Hitbox(550.0f * Settings.scale, 770.0f * Settings.scale);
        this.cardHb.move((float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f);
        this.card = card.makeStatEquivalentCopy();
        this.portraitImg = ImageMaster.loadImage("images/1024Portraits/" + card.assetURL + ".png");
        this.group = group;
        this.isOpen = true;
        this.fadeTimer = 0.25f;
        this.fadeColor.a = 0.0f;
        this.current_x = (float)Settings.WIDTH / 2.0f - 10.0f * Settings.scale;
        this.current_y = (float)Settings.HEIGHT / 2.0f - 300.0f * Settings.scale;
        this.upgradeHb.move((float)Settings.WIDTH / 2.0f, 70.0f * Settings.scale);
    }

    public void open(AbstractCard card) {
        CardCrawlGame.isPopupOpen = true;
        if (CardCrawlGame.mode == CardCrawlGame.GameMode.CHAR_SELECT) {
            // empty if block
        }
        this.prevCard = null;
        this.nextCard = null;
        this.prevHb = null;
        this.nextHb = null;
        this.card_energy_w = 24.0f * Settings.scale;
        this.drawScale = 2.0f;
        this.cardHb = new Hitbox(550.0f * Settings.scale, 770.0f * Settings.scale);
        this.cardHb.move((float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f);
        this.card = card.makeStatEquivalentCopy();
        this.portraitImg = ImageMaster.loadImage("images/1024Portraits/" + card.assetURL + ".png");
        this.group = null;
        this.isOpen = true;
        this.fadeTimer = 0.25f;
        this.fadeColor.a = 0.0f;
        this.current_x = (float)Settings.WIDTH / 2.0f - 10.0f * Settings.scale;
        this.current_y = (float)Settings.HEIGHT / 2.0f - 300.0f * Settings.scale;
        this.upgradeHb.move((float)Settings.WIDTH / 2.0f, 70.0f * Settings.scale);
    }

    public void close() {
        isViewingUpgrade = false;
        InputHelper.justReleasedClickLeft = false;
        CardCrawlGame.isPopupOpen = false;
        this.isOpen = false;
        if (this.portraitImg != null) {
            this.portraitImg.dispose();
            this.portraitImg = null;
        }
    }

    public void update() {
        this.cardHb.update();
        this.updateArrows();
        this.updateInput();
        this.updateFade();
        if (this.card.color == AbstractCard.CardColor.RED || this.card.color == AbstractCard.CardColor.GREEN || this.card.color == AbstractCard.CardColor.BLUE) {
            this.updateUpgradePreview();
        }
    }

    private void updateUpgradePreview() {
        this.upgradeHb.update();
        if (this.upgradeHb.hovered && InputHelper.justClickedLeft) {
            this.upgradeHb.clickStarted = true;
        }
        if (this.upgradeHb.clicked) {
            this.upgradeHb.clicked = false;
            isViewingUpgrade = !isViewingUpgrade;
        }
    }

    private void updateArrows() {
        if (this.prevCard != null) {
            this.prevHb.update();
            if (this.prevHb.justHovered) {
                CardCrawlGame.sound.play("UI_HOVER");
            }
            if (this.prevHb.clicked) {
                this.openPrev();
            }
        }
        if (this.nextCard != null) {
            this.nextHb.update();
            if (this.nextHb.justHovered) {
                CardCrawlGame.sound.play("UI_HOVER");
            }
            if (this.nextHb.clicked) {
                this.openNext();
            }
        }
    }

    private void updateInput() {
        if (InputHelper.justClickedLeft) {
            if (this.prevCard != null && this.prevHb.hovered) {
                this.prevHb.clickStarted = true;
                CardCrawlGame.sound.play("UI_CLICK_1");
                return;
            }
            if (this.nextCard != null && this.nextHb.hovered) {
                this.nextHb.clickStarted = true;
                CardCrawlGame.sound.play("UI_CLICK_1");
                return;
            }
        }
        if (InputHelper.justReleasedClickLeft) {
            if (!this.cardHb.hovered && !this.upgradeHb.hovered) {
                this.close();
            }
        } else if (InputHelper.pressedEscape) {
            InputHelper.pressedEscape = false;
            this.close();
        }
        if (this.prevCard != null && Gdx.input.isKeyJustPressed(21)) {
            this.openPrev();
        } else if (this.nextCard != null && Gdx.input.isKeyJustPressed(22)) {
            this.openNext();
        }
    }

    private void openPrev() {
        boolean tmp = isViewingUpgrade;
        this.close();
        this.open(this.prevCard, this.group);
        isViewingUpgrade = tmp;
        this.fadeTimer = 0.0f;
        this.fadeColor.a = 0.9f;
    }

    private void openNext() {
        boolean tmp = isViewingUpgrade;
        this.close();
        this.open(this.nextCard, this.group);
        isViewingUpgrade = tmp;
        this.fadeTimer = 0.0f;
        this.fadeColor.a = 0.9f;
    }

    private void updateFade() {
        this.fadeTimer -= Gdx.graphics.getDeltaTime();
        if (this.fadeTimer < 0.0f) {
            this.fadeTimer = 0.0f;
        }
        this.fadeColor.a = Interpolation.pow2In.apply(0.9f, 0.0f, this.fadeTimer * 4.0f);
    }

    public void render(SpriteBatch sb) {
        AbstractCard copy = null;
        if (isViewingUpgrade) {
            copy = this.card.makeStatEquivalentCopy();
            this.card.upgrade();
            this.card.displayUpgrades();
        }
        sb.setColor(this.fadeColor);
        sb.draw(ImageMaster.WHITE_SQUARE_IMG, 0.0f, 0.0f, (float)Settings.WIDTH, (float)Settings.HEIGHT);
        sb.setColor(Color.WHITE);
        this.renderCardBack(sb);
        this.renderPortrait(sb);
        this.renderFrame(sb);
        this.renderCardBanner(sb);
        this.renderCardTypeText(sb);
        if (Settings.lineBreakViaCharacter) {
            this.renderDescriptionCN(sb);
        } else {
            this.renderDescription(sb);
        }
        this.renderTitle(sb);
        this.renderCost(sb);
        this.renderArrows(sb);
        this.renderTips(sb);
        this.cardHb.render(sb);
        if (this.nextHb != null) {
            this.nextHb.render(sb);
        }
        if (this.prevHb != null) {
            this.prevHb.render(sb);
        }
        if (this.card.color == AbstractCard.CardColor.RED || this.card.color == AbstractCard.CardColor.GREEN || this.card.color == AbstractCard.CardColor.BLUE) {
            this.renderUpgradeViewToggle(sb);
        }
        if (copy != null) {
            this.card = copy;
        }
    }

    public void renderCardBack(SpriteBatch sb) {
        Texture tmpImg = null;
        block0 : switch (this.card.type) {
            case ATTACK: {
                switch (this.card.color) {
                    case RED: {
                        tmpImg = ImageMaster.CARD_ATTACK_BG_RED_L;
                        break block0;
                    }
                    case GREEN: {
                        tmpImg = ImageMaster.CARD_ATTACK_BG_GREEN_L;
                        break block0;
                    }
                    case BLUE: {
                        tmpImg = ImageMaster.CARD_ATTACK_BG_BLUE_L;
                        break block0;
                    }
                    case COLORLESS: {
                        tmpImg = ImageMaster.CARD_ATTACK_BG_GRAY_L;
                        break block0;
                    }
                }
                break;
            }
            case POWER: {
                switch (this.card.color) {
                    case RED: {
                        tmpImg = ImageMaster.CARD_POWER_BG_RED_L;
                        break block0;
                    }
                    case GREEN: {
                        tmpImg = ImageMaster.CARD_POWER_BG_GREEN_L;
                        break block0;
                    }
                    case BLUE: {
                        tmpImg = ImageMaster.CARD_POWER_BG_BLUE_L;
                        break block0;
                    }
                    case COLORLESS: {
                        tmpImg = ImageMaster.CARD_POWER_BG_GRAY_L;
                        break block0;
                    }
                }
                break;
            }
            default: {
                switch (this.card.color) {
                    case RED: {
                        tmpImg = ImageMaster.CARD_SKILL_BG_RED_L;
                        break block0;
                    }
                    case GREEN: {
                        tmpImg = ImageMaster.CARD_SKILL_BG_GREEN_L;
                        break block0;
                    }
                    case BLUE: {
                        tmpImg = ImageMaster.CARD_SKILL_BG_BLUE_L;
                        break block0;
                    }
                    case COLORLESS: {
                        tmpImg = ImageMaster.CARD_SKILL_BG_GRAY_L;
                        break block0;
                    }
                    case CURSE: {
                        tmpImg = ImageMaster.CARD_SKILL_BG_BLACK_L;
                        break block0;
                    }
                }
            }
        }
        if (tmpImg == null) {
            return;
        }
        sb.draw(tmpImg, (float)Settings.WIDTH / 2.0f - 512.0f, (float)Settings.HEIGHT / 2.0f - 512.0f, 512.0f, 512.0f, 1024.0f, 1024.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 1024, 1024, false, false);
    }

    private void renderPortrait(SpriteBatch sb) {
        if (this.card.isLocked) {
            switch (this.card.type) {
                case ATTACK: {
                    sb.draw(ImageMaster.CARD_LOCKED_ATTACK_L, (float)Settings.WIDTH / 2.0f - 250.0f, (float)Settings.HEIGHT / 2.0f - 190.0f + 136.0f * Settings.scale, 250.0f, 190.0f, 500.0f, 380.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 500, 380, false, false);
                    break;
                }
                case SKILL: {
                    sb.draw(ImageMaster.CARD_LOCKED_SKILL_L, (float)Settings.WIDTH / 2.0f - 250.0f, (float)Settings.HEIGHT / 2.0f - 190.0f + 136.0f * Settings.scale, 250.0f, 190.0f, 500.0f, 380.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 500, 380, false, false);
                    break;
                }
                case POWER: {
                    sb.draw(ImageMaster.CARD_LOCKED_POWER_L, (float)Settings.WIDTH / 2.0f - 250.0f, (float)Settings.HEIGHT / 2.0f - 190.0f + 136.0f * Settings.scale, 250.0f, 190.0f, 500.0f, 380.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 500, 380, false, false);
                    break;
                }
                default: {
                    sb.draw(ImageMaster.CARD_LOCKED_SKILL_L, (float)Settings.WIDTH / 2.0f - 250.0f, (float)Settings.HEIGHT / 2.0f - 190.0f + 136.0f * Settings.scale, 250.0f, 190.0f, 500.0f, 380.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 500, 380, false, false);
                    break;
                }
            }
        } else if (this.portraitImg != null) {
            sb.draw(this.portraitImg, (float)Settings.WIDTH / 2.0f - 250.0f, (float)Settings.HEIGHT / 2.0f - 190.0f + 136.0f * Settings.scale, 250.0f, 190.0f, 500.0f, 380.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 500, 380, false, false);
        }
    }

    private void renderFrame(SpriteBatch sb) {
        Texture tmpImg = null;
        block0 : switch (this.card.type) {
            case ATTACK: {
                switch (this.card.rarity) {
                    case COMMON: {
                        tmpImg = ImageMaster.CARD_FRAME_ATTACK_COMMON_L;
                        break block0;
                    }
                    case UNCOMMON: {
                        tmpImg = ImageMaster.CARD_FRAME_ATTACK_UNCOMMON_L;
                        break block0;
                    }
                    case RARE: {
                        tmpImg = ImageMaster.CARD_FRAME_ATTACK_RARE_L;
                        break block0;
                    }
                }
                tmpImg = ImageMaster.CARD_FRAME_ATTACK_COMMON_L;
                break;
            }
            case POWER: {
                switch (this.card.rarity) {
                    case COMMON: {
                        tmpImg = ImageMaster.CARD_FRAME_POWER_COMMON_L;
                        break block0;
                    }
                    case UNCOMMON: {
                        tmpImg = ImageMaster.CARD_FRAME_POWER_UNCOMMON_L;
                        break block0;
                    }
                    case RARE: {
                        tmpImg = ImageMaster.CARD_FRAME_POWER_RARE_L;
                        break block0;
                    }
                }
                tmpImg = ImageMaster.CARD_FRAME_POWER_COMMON_L;
                break;
            }
            default: {
                switch (this.card.rarity) {
                    case COMMON: {
                        tmpImg = ImageMaster.CARD_FRAME_SKILL_COMMON_L;
                        break block0;
                    }
                    case UNCOMMON: {
                        tmpImg = ImageMaster.CARD_FRAME_SKILL_UNCOMMON_L;
                        break block0;
                    }
                    case RARE: {
                        tmpImg = ImageMaster.CARD_FRAME_SKILL_RARE_L;
                        break block0;
                    }
                }
                tmpImg = ImageMaster.CARD_FRAME_SKILL_COMMON_L;
            }
        }
        sb.draw(tmpImg, (float)Settings.WIDTH / 2.0f - 512.0f, (float)Settings.HEIGHT / 2.0f - 512.0f, 512.0f, 512.0f, 1024.0f, 1024.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 1024, 1024, false, false);
    }

    private void renderCardBanner(SpriteBatch sb) {
        Texture tmpImg = null;
        switch (this.card.rarity) {
            case COMMON: {
                tmpImg = ImageMaster.CARD_BANNER_COMMON_L;
                break;
            }
            case UNCOMMON: {
                tmpImg = ImageMaster.CARD_BANNER_UNCOMMON_L;
                break;
            }
            case RARE: {
                tmpImg = ImageMaster.CARD_BANNER_RARE_L;
                break;
            }
            default: {
                tmpImg = ImageMaster.CARD_BANNER_COMMON_L;
            }
        }
        sb.draw(tmpImg, (float)Settings.WIDTH / 2.0f - 512.0f, (float)Settings.HEIGHT / 2.0f - 512.0f, 512.0f, 512.0f, 1024.0f, 1024.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 1024, 1024, false, false);
    }

    private String getDynamicValue(char key) {
        switch (key) {
            case 'B': {
                if (this.card.isBlockModified) {
                    if (this.card.block >= this.card.baseBlock) {
                        return "[#7fff00]" + Integer.toString(this.card.block) + "[]";
                    }
                    return "[#ff6563]" + Integer.toString(this.card.block) + "[]";
                }
                return Integer.toString(this.card.baseBlock);
            }
            case 'D': {
                if (this.card.isDamageModified) {
                    if (this.card.damage >= this.card.baseDamage) {
                        return "[#7fff00]" + Integer.toString(this.card.damage) + "[]";
                    }
                    return "[#ff6563]" + Integer.toString(this.card.damage) + "[]";
                }
                return Integer.toString(this.card.baseDamage);
            }
            case 'M': {
                if (this.card.isMagicNumberModified) {
                    if (this.card.magicNumber >= this.card.baseMagicNumber) {
                        return "[#7fff00]" + Integer.toString(this.card.magicNumber) + "[]";
                    }
                    return "[#ff6563]" + Integer.toString(this.card.magicNumber) + "[]";
                }
                return Integer.toString(this.card.baseMagicNumber);
            }
        }
        System.out.println("KEY: " + key);
        return Integer.toString(-99);
    }

    private void renderDescriptionCN(SpriteBatch sb) {
        if (this.card.isLocked || !this.card.isSeen) {
            FontHelper.renderFontCentered(sb, FontHelper.largeCardFont, "? ? ?", (float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f - 195.0f * Settings.scale, Settings.CREAM_COLOR);
            return;
        }
        BitmapFont font = FontHelper.SCP_cardDescFont;
        float draw_y = this.current_y + 100.0f * Settings.scale;
        draw_y += (float)this.card.description.size() * font.getCapHeight() * 0.775f - font.getCapHeight() * 0.375f;
        float spacing = 1.53f * -font.getCapHeight() / Settings.scale / this.drawScale;
        GlyphLayout gl = new GlyphLayout();
        for (int i = 0; i < this.card.description.size(); ++i) {
            float start_x = this.current_x - this.card.description.get((int)i).width * this.drawScale / 2.0f - 20.0f * Settings.scale;
            this.scanner = new Scanner(this.card.description.get((int)i).text);
            while (this.scanner.hasNext()) {
                int j;
                String tmp = this.scanner.next();
                tmp = tmp.replace("!", "");
                String updateTmp = null;
                for (j = 0; j < tmp.length(); ++j) {
                    if (tmp.charAt(j) != 'D' && tmp.charAt(j) != 'B' && tmp.charAt(j) != 'M') continue;
                    updateTmp = tmp.substring(0, j);
                    updateTmp = updateTmp + this.getDynamicValue(tmp.charAt(j));
                    updateTmp = updateTmp + tmp.substring(j + 1);
                    break;
                }
                if (updateTmp != null) {
                    tmp = updateTmp;
                }
                for (j = 0; j < tmp.length(); ++j) {
                    if (tmp.charAt(j) != 'D' && tmp.charAt(j) != 'B' && tmp.charAt(j) != 'M') continue;
                    updateTmp = tmp.substring(0, j);
                    updateTmp = updateTmp + this.getDynamicValue(tmp.charAt(j));
                    updateTmp = updateTmp + tmp.substring(j + 1);
                    break;
                }
                if (updateTmp != null) {
                    tmp = updateTmp;
                }
                if (tmp.charAt(0) == '*') {
                    tmp = tmp.substring(1);
                    String punctuation = "";
                    if (tmp.length() > 1 && !Character.isLetter(tmp.charAt(tmp.length() - 2))) {
                        punctuation = punctuation + tmp.charAt(tmp.length() - 2);
                        tmp = tmp.substring(0, tmp.length() - 2);
                        punctuation = punctuation + ' ';
                    }
                    gl.setText(font, tmp);
                    FontHelper.renderRotatedText(sb, font, tmp, this.current_x, this.current_y, start_x - this.current_x + gl.width / 2.0f, (float)i * 1.53f * -font.getCapHeight() + draw_y - this.current_y + -12.0f, 0.0f, true, Settings.GOLD_COLOR.cpy());
                    start_x = Math.round(start_x + gl.width);
                    gl.setText(font, punctuation);
                    FontHelper.renderRotatedText(sb, font, punctuation, this.current_x, this.current_y, start_x - this.current_x + gl.width / 2.0f, (float)i * 1.53f * -font.getCapHeight() + draw_y - this.current_y + -12.0f, 0.0f, true, Settings.CREAM_COLOR.cpy());
                    gl.setText(font, punctuation);
                    start_x += gl.width;
                    continue;
                }
                if (tmp.equals("[R]")) {
                    gl.width = this.card_energy_w * this.drawScale;
                    float tmp2 = (float)(this.card.description.size() - 4) * spacing;
                    this.renderSmallEnergy(sb, ImageMaster.RED_ORB, (start_x - this.current_x) / Settings.scale / this.drawScale, -tmp2 - 172.0f + this.card_energy_w * this.drawScale / Settings.scale + (float)i * spacing * 2.0f);
                    start_x += gl.width;
                    continue;
                }
                if (tmp.equals("[G]")) {
                    gl.width = this.card_energy_w * this.drawScale;
                    float tmp2 = (float)(this.card.description.size() - 4) * spacing;
                    this.renderSmallEnergy(sb, ImageMaster.GREEN_ORB, (start_x - this.current_x) / Settings.scale / this.drawScale, -tmp2 - 172.0f + this.card_energy_w * this.drawScale / Settings.scale + (float)i * spacing * 2.0f);
                    start_x += gl.width;
                    continue;
                }
                if (tmp.equals("[B] ")) {
                    gl.width = this.card_energy_w * this.drawScale;
                    float tmp2 = (float)(this.card.description.size() - 4) * spacing;
                    this.renderSmallEnergy(sb, ImageMaster.BLUE_ORB, (start_x - this.current_x) / Settings.scale / this.drawScale, -tmp2 - 172.0f + this.card_energy_w * this.drawScale / Settings.scale + (float)i * spacing * 2.0f);
                    start_x += gl.width;
                    continue;
                }
                gl.setText(font, tmp);
                FontHelper.renderRotatedText(sb, font, tmp, this.current_x, this.current_y, start_x - this.current_x + gl.width / 2.0f, (float)i * 1.53f * -font.getCapHeight() + draw_y - this.current_y + -12.0f, 0.0f, true, Settings.CREAM_COLOR);
                start_x += gl.width;
            }
        }
        font.getData().setScale(1.0f);
    }

    private void renderDescription(SpriteBatch sb) {
        if (this.card.isLocked || !this.card.isSeen) {
            FontHelper.renderFontCentered(sb, FontHelper.largeCardFont, "? ? ?", (float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f - 195.0f * Settings.scale, Settings.CREAM_COLOR);
            return;
        }
        BitmapFont font = FontHelper.SCP_cardDescFont;
        float draw_y = this.current_y + 100.0f * Settings.scale;
        draw_y += (float)this.card.description.size() * font.getCapHeight() * 0.775f - font.getCapHeight() * 0.375f;
        float spacing = 1.53f * -font.getCapHeight() / Settings.scale / this.drawScale;
        GlyphLayout gl = new GlyphLayout();
        for (int i = 0; i < this.card.description.size(); ++i) {
            float start_x = this.current_x - this.card.description.get((int)i).width * this.drawScale / 2.0f;
            this.scanner = new Scanner(this.card.description.get((int)i).text);
            while (this.scanner.hasNext()) {
                String tmp = this.scanner.next() + ' ';
                if (tmp.charAt(0) == '*') {
                    tmp = tmp.substring(1);
                    String punctuation = "";
                    if (tmp.length() > 1 && !Character.isLetter(tmp.charAt(tmp.length() - 2))) {
                        punctuation = punctuation + tmp.charAt(tmp.length() - 2);
                        tmp = tmp.substring(0, tmp.length() - 2);
                        punctuation = punctuation + ' ';
                    }
                    gl.setText(font, tmp);
                    FontHelper.renderRotatedText(sb, font, tmp, this.current_x, this.current_y, start_x - this.current_x + gl.width / 2.0f, (float)i * 1.53f * -font.getCapHeight() + draw_y - this.current_y + -12.0f, 0.0f, true, Settings.GOLD_COLOR.cpy());
                    start_x = Math.round(start_x + gl.width);
                    gl.setText(font, punctuation);
                    FontHelper.renderRotatedText(sb, font, punctuation, this.current_x, this.current_y, start_x - this.current_x + gl.width / 2.0f, (float)i * 1.53f * -font.getCapHeight() + draw_y - this.current_y + -12.0f, 0.0f, true, Settings.CREAM_COLOR.cpy());
                    gl.setText(font, punctuation);
                    start_x += gl.width;
                    continue;
                }
                if (tmp.charAt(0) == '!') {
                    start_x += this.renderDynamicVariable(tmp.charAt(1), start_x, draw_y, i, font, sb);
                    continue;
                }
                if (tmp.equals("[R] ")) {
                    gl.width = this.card_energy_w * this.drawScale;
                    float tmp2 = (float)(this.card.description.size() - 4) * spacing;
                    this.renderSmallEnergy(sb, ImageMaster.RED_ORB, (start_x - this.current_x) / Settings.scale / this.drawScale, -tmp2 - 172.0f + this.card_energy_w * this.drawScale / Settings.scale + (float)i * spacing * 2.0f);
                    start_x += gl.width;
                    continue;
                }
                if (tmp.equals("[R]. ")) {
                    gl.width = this.card_energy_w * this.drawScale / Settings.scale;
                    float tmp2 = (float)(this.card.description.size() - 4) * spacing;
                    this.renderSmallEnergy(sb, ImageMaster.RED_ORB, (start_x - this.current_x) / Settings.scale / this.drawScale, -tmp2 - 172.0f + this.card_energy_w * this.drawScale / Settings.scale + (float)i * spacing * 2.0f);
                    FontHelper.renderRotatedText(sb, font, ".", this.current_x, this.current_y, start_x - this.current_x + this.card_energy_w * this.drawScale, (float)i * 1.53f * -font.getCapHeight() + draw_y - this.current_y + -12.0f, 0.0f, true, Settings.CREAM_COLOR);
                    start_x += gl.width;
                    gl.setText(font, ".");
                    start_x += gl.width;
                    continue;
                }
                if (tmp.equals("[G] ")) {
                    gl.width = this.card_energy_w * this.drawScale;
                    float tmp2 = (float)(this.card.description.size() - 4) * spacing;
                    this.renderSmallEnergy(sb, ImageMaster.GREEN_ORB, (start_x - this.current_x) / Settings.scale / this.drawScale, -tmp2 - 172.0f + this.card_energy_w * this.drawScale / Settings.scale + (float)i * spacing * 2.0f);
                    start_x += gl.width;
                    continue;
                }
                if (tmp.equals("[G]. ")) {
                    gl.width = this.card_energy_w * this.drawScale;
                    float tmp2 = (float)(this.card.description.size() - 4) * spacing;
                    this.renderSmallEnergy(sb, ImageMaster.GREEN_ORB, (start_x - this.current_x) / Settings.scale / this.drawScale, -tmp2 - 172.0f + this.card_energy_w * this.drawScale / Settings.scale + (float)i * spacing * 2.0f);
                    FontHelper.renderRotatedText(sb, font, ".", this.current_x, this.current_y, start_x - this.current_x + this.card_energy_w * this.drawScale, (float)i * 1.53f * -font.getCapHeight() + draw_y - this.current_y + -12.0f, 0.0f, true, Settings.CREAM_COLOR);
                    start_x += gl.width;
                    continue;
                }
                if (tmp.equals("[B] ")) {
                    gl.width = this.card_energy_w * this.drawScale;
                    float tmp2 = (float)(this.card.description.size() - 4) * spacing;
                    this.renderSmallEnergy(sb, ImageMaster.BLUE_ORB, (start_x - this.current_x) / Settings.scale / this.drawScale, -tmp2 - 172.0f + this.card_energy_w * this.drawScale / Settings.scale + (float)i * spacing * 2.0f);
                    start_x += gl.width;
                    continue;
                }
                if (tmp.equals("[B]. ")) {
                    gl.width = this.card_energy_w * this.drawScale;
                    float tmp2 = (float)(this.card.description.size() - 4) * spacing;
                    this.renderSmallEnergy(sb, ImageMaster.BLUE_ORB, (start_x - this.current_x) / Settings.scale / this.drawScale, -tmp2 - 172.0f + this.card_energy_w * this.drawScale / Settings.scale + (float)i * spacing * 2.0f);
                    FontHelper.renderRotatedText(sb, font, ".", this.current_x, this.current_y, start_x - this.current_x + this.card_energy_w * this.drawScale, (float)i * 1.53f * -font.getCapHeight() + draw_y - this.current_y + -12.0f, 0.0f, true, Settings.CREAM_COLOR);
                    start_x += gl.width;
                    continue;
                }
                gl.setText(font, tmp);
                FontHelper.renderRotatedText(sb, font, tmp, this.current_x, this.current_y, start_x - this.current_x + gl.width / 2.0f, (float)i * 1.53f * -font.getCapHeight() + draw_y - this.current_y + -12.0f, 0.0f, true, Settings.CREAM_COLOR);
                start_x += gl.width;
            }
        }
        font.getData().setScale(1.0f);
    }

    private void renderSmallEnergy(SpriteBatch sb, TextureAtlas.AtlasRegion region, float x, float y) {
        sb.setColor(Color.WHITE);
        sb.draw(region.getTexture(), this.current_x + x * Settings.scale * this.drawScale + region.offsetX * Settings.scale - 4.0f * Settings.scale, this.current_y + y * Settings.scale * this.drawScale / 2.0f + 280.0f * Settings.scale, 0.0f, 0.0f, region.packedWidth, region.packedHeight, this.drawScale * Settings.scale, this.drawScale * Settings.scale, 0.0f, region.getRegionX(), region.getRegionY(), region.getRegionWidth(), region.getRegionHeight(), false, false);
    }

    private void renderCardTypeText(SpriteBatch sb) {
        String label = "";
        switch (this.card.type) {
            case ATTACK: {
                label = TEXT[0];
                break;
            }
            case SKILL: {
                label = TEXT[1];
                break;
            }
            case POWER: {
                label = TEXT[2];
                break;
            }
            case CURSE: {
                label = TEXT[3];
                break;
            }
            case STATUS: {
                label = TEXT[7];
                break;
            }
        }
        FontHelper.renderFontCentered(sb, FontHelper.SCP_cardTypeFont, label, (float)Settings.WIDTH / 2.0f + 3.0f * Settings.scale, (float)Settings.HEIGHT / 2.0f - 40.0f * Settings.scale, CARD_TYPE_COLOR);
    }

    private float renderDynamicVariable(char key, float start_x, float draw_y, int i, BitmapFont font, SpriteBatch sb) {
        switch (key) {
            case 'D': {
                gl.setText(font, Integer.toString(this.card.baseDamage));
                if (this.card.upgradedDamage) {
                    FontHelper.renderRotatedText(sb, font, Integer.toString(this.card.baseDamage), this.current_x, this.current_y, start_x - this.current_x + SingleCardViewPopup.gl.width / 2.0f, (float)i * 1.53f * -font.getCapHeight() + draw_y - this.current_y + -12.0f, 0.0f, true, Settings.GREEN_TEXT_COLOR);
                } else {
                    FontHelper.renderRotatedText(sb, font, Integer.toString(this.card.baseDamage), this.current_x, this.current_y, start_x - this.current_x + SingleCardViewPopup.gl.width / 2.0f, (float)i * 1.53f * -font.getCapHeight() + draw_y - this.current_y + -12.0f, 0.0f, true, Settings.CREAM_COLOR);
                }
                gl.setText(font, Integer.toString(this.card.baseDamage) + ' ');
                return SingleCardViewPopup.gl.width;
            }
            case 'B': {
                gl.setText(font, Integer.toString(this.card.baseBlock));
                if (this.card.upgradedBlock) {
                    FontHelper.renderRotatedText(sb, font, Integer.toString(this.card.baseBlock), this.current_x, this.current_y, start_x - this.current_x + SingleCardViewPopup.gl.width / 2.0f, (float)i * 1.53f * -font.getCapHeight() + draw_y - this.current_y + -12.0f, 0.0f, true, Settings.GREEN_TEXT_COLOR);
                } else {
                    FontHelper.renderRotatedText(sb, font, Integer.toString(this.card.baseBlock), this.current_x, this.current_y, start_x - this.current_x + SingleCardViewPopup.gl.width / 2.0f, (float)i * 1.53f * -font.getCapHeight() + draw_y - this.current_y + -12.0f, 0.0f, true, Settings.CREAM_COLOR);
                }
                gl.setText(font, Integer.toString(this.card.baseBlock) + ' ');
                return SingleCardViewPopup.gl.width;
            }
            case 'M': {
                gl.setText(font, Integer.toString(this.card.baseMagicNumber));
                if (this.card.upgradedMagicNumber) {
                    FontHelper.renderRotatedText(sb, font, Integer.toString(this.card.baseMagicNumber), this.current_x, this.current_y, start_x - this.current_x + SingleCardViewPopup.gl.width / 2.0f, (float)i * 1.53f * -font.getCapHeight() + draw_y - this.current_y + -12.0f, 0.0f, true, Settings.GREEN_TEXT_COLOR);
                } else {
                    FontHelper.renderRotatedText(sb, font, Integer.toString(this.card.baseMagicNumber), this.current_x, this.current_y, start_x - this.current_x + SingleCardViewPopup.gl.width / 2.0f, (float)i * 1.53f * -font.getCapHeight() + draw_y - this.current_y + -12.0f, 0.0f, true, Settings.CREAM_COLOR);
                }
                gl.setText(font, Integer.toString(this.card.baseMagicNumber) + ' ');
                return SingleCardViewPopup.gl.width;
            }
        }
        return 0.0f;
    }

    private void renderTitle(SpriteBatch sb) {
        if (this.card.isLocked) {
            FontHelper.renderFontCentered(sb, FontHelper.SCP_cardTitleFont_small, TEXT[4], (float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f + 338.0f * Settings.scale, Settings.CREAM_COLOR);
        } else if (this.card.isSeen) {
            if (!isViewingUpgrade || this.card.color == AbstractCard.CardColor.COLORLESS || this.card.color == AbstractCard.CardColor.CURSE) {
                FontHelper.renderFontCentered(sb, FontHelper.SCP_cardTitleFont_small, this.card.name, (float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f + 338.0f * Settings.scale, Settings.CREAM_COLOR);
            } else {
                FontHelper.renderFontCentered(sb, FontHelper.SCP_cardTitleFont_small, this.card.name, (float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f + 338.0f * Settings.scale, Settings.GREEN_TEXT_COLOR);
            }
        } else {
            FontHelper.renderFontCentered(sb, FontHelper.SCP_cardTitleFont_small, TEXT[5], (float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f + 338.0f * Settings.scale, Settings.CREAM_COLOR);
        }
    }

    private void renderCost(SpriteBatch sb) {
        if (this.card.isLocked || !this.card.isSeen) {
            return;
        }
        if (this.card.cost > -2) {
            switch (this.card.color) {
                case RED: {
                    sb.draw(ImageMaster.CARD_RED_ORB_L, (float)Settings.WIDTH / 2.0f - 82.0f - 270.0f * Settings.scale, (float)Settings.HEIGHT / 2.0f - 82.0f + 380.0f * Settings.scale, 82.0f, 82.0f, 164.0f, 164.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 164, 164, false, false);
                    break;
                }
                case GREEN: {
                    sb.draw(ImageMaster.CARD_GREEN_ORB_L, (float)Settings.WIDTH / 2.0f - 82.0f - 270.0f * Settings.scale, (float)Settings.HEIGHT / 2.0f - 82.0f + 380.0f * Settings.scale, 82.0f, 82.0f, 164.0f, 164.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 164, 164, false, false);
                    break;
                }
                case BLUE: {
                    break;
                }
                case COLORLESS: {
                    sb.draw(ImageMaster.CARD_GRAY_ORB_L, (float)Settings.WIDTH / 2.0f - 82.0f - 270.0f * Settings.scale, (float)Settings.HEIGHT / 2.0f - 82.0f + 380.0f * Settings.scale, 82.0f, 82.0f, 164.0f, 164.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 164, 164, false, false);
                    break;
                }
            }
        }
        Color c = null;
        c = this.card.isCostModified ? Settings.GREEN_TEXT_COLOR : Settings.CREAM_COLOR;
        switch (this.card.cost) {
            case -2: {
                break;
            }
            case -1: {
                FontHelper.renderFont(sb, FontHelper.SCP_cardEnergyFont, "X", 666.0f * Settings.scale, (float)Settings.HEIGHT / 2.0f + 404.0f * Settings.scale, c);
                break;
            }
            case 1: {
                FontHelper.renderFont(sb, FontHelper.SCP_cardEnergyFont, Integer.toString(this.card.cost), 674.0f * Settings.scale, (float)Settings.HEIGHT / 2.0f + 404.0f * Settings.scale, c);
                break;
            }
            default: {
                FontHelper.renderFont(sb, FontHelper.SCP_cardEnergyFont, Integer.toString(this.card.cost), 668.0f * Settings.scale, (float)Settings.HEIGHT / 2.0f + 404.0f * Settings.scale, c);
            }
        }
    }

    private void renderArrows(SpriteBatch sb) {
        if (this.prevCard != null) {
            sb.draw(ImageMaster.POPUP_ARROW, this.prevHb.cX - 128.0f, this.prevHb.cY - 128.0f, 128.0f, 128.0f, 256.0f, 256.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 256, 256, false, false);
            if (this.prevHb.hovered) {
                sb.setBlendFunction(770, 1);
                sb.setColor(new Color(1.0f, 1.0f, 1.0f, 0.5f));
                sb.draw(ImageMaster.POPUP_ARROW, this.prevHb.cX - 128.0f, this.prevHb.cY - 128.0f, 128.0f, 128.0f, 256.0f, 256.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 256, 256, false, false);
                sb.setColor(Color.WHITE);
                sb.setBlendFunction(770, 771);
            }
        }
        if (this.nextCard != null) {
            sb.draw(ImageMaster.POPUP_ARROW, this.nextHb.cX - 128.0f, this.nextHb.cY - 128.0f, 128.0f, 128.0f, 256.0f, 256.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 256, 256, true, false);
            if (this.nextHb.hovered) {
                sb.setBlendFunction(770, 1);
                sb.setColor(new Color(1.0f, 1.0f, 1.0f, 0.5f));
                sb.draw(ImageMaster.POPUP_ARROW, this.nextHb.cX - 128.0f, this.nextHb.cY - 128.0f, 128.0f, 128.0f, 256.0f, 256.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 256, 256, true, false);
                sb.setColor(Color.WHITE);
                sb.setBlendFunction(770, 771);
            }
        }
    }

    private void renderUpgradeViewToggle(SpriteBatch sb) {
        sb.setColor(Color.WHITE);
        sb.draw(ImageMaster.OPTION_TOGGLE, 870.0f * Settings.scale - 16.0f, 70.0f * Settings.scale - 16.0f, 16.0f, 16.0f, 32.0f, 32.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 32, 32, false, false);
        if (this.upgradeHb.hovered && !isViewingUpgrade) {
            FontHelper.renderFont(sb, FontHelper.cardTitleFont_N, TEXT[6], 900.0f * Settings.scale, 80.0f * Settings.scale, Settings.BLUE_TEXT_COLOR);
        } else {
            FontHelper.renderFont(sb, FontHelper.cardTitleFont_N, TEXT[6], 900.0f * Settings.scale, 80.0f * Settings.scale, Settings.GOLD_COLOR);
        }
        if (isViewingUpgrade) {
            sb.setColor(Color.WHITE);
            sb.draw(ImageMaster.OPTION_TOGGLE_ON, 870.0f * Settings.scale - 16.0f, 70.0f * Settings.scale - 16.0f, 16.0f, 16.0f, 32.0f, 32.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 32, 32, false, false);
        }
        this.upgradeHb.render(sb);
    }

    private void renderTips(SpriteBatch sb) {
        ArrayList<PowerTip> t = new ArrayList<PowerTip>();
        if (this.card.isLocked) {
            t.add(new PowerTip(TEXT[4], GameDictionary.keywords.get(TEXT[4].toLowerCase())));
        } else if (!this.card.isSeen) {
            t.add(new PowerTip(TEXT[5], GameDictionary.keywords.get(TEXT[5].toLowerCase())));
        } else {
            for (String s : this.card.keywords) {
                if (s.equals("[R]") || s.equals("[G]") || s.equals("[B]")) continue;
                t.add(new PowerTip(TipHelper.capitalize(s), GameDictionary.keywords.get(s)));
            }
        }
        if (!t.isEmpty()) {
            TipHelper.queuePowerTips(1300.0f * Settings.scale, 440.0f * Settings.scale, t);
        }
    }
}

